/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.blocks;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.blocks.Block;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityFurnace;
import dangerzone.gui.GuiInterface;
import dangerzone.rendering.StitchedTexture;
import dangerzone.world.World;
import java.util.List;
import java.util.ListIterator;
import slick.Texture;

public class CrystalFurnace
extends Block {
    Texture ttop = null;
    Texture tfront = null;
    Texture tside = null;
    String topname = "orespawnres/blocks/crystalfurnace_top.png";
    String frontname = "orespawnres/blocks/crystalfurnace_front_off.png";
    String sidename = "orespawnres/blocks/crystalfurnace_side.png";
    StitchedTexture sttop = new StitchedTexture();
    StitchedTexture stfront = new StitchedTexture();
    StitchedTexture stside = new StitchedTexture();

    public CrystalFurnace(String n) {
        super(n, "");
        this.maxstack = 8;
        this.isStone = true;
        this.hasFront = true;
        this.renderAllSides = true;
        this.renderSmaller = true;
        this.isSolidForRendering = false;
    }

    public boolean rightClickOnBlock(Player p, int dimension, int x, int y, int z, int s) {
        if (p == null || p.world.isServer) {
            return false;
        }
        List nearby_list = null;
        EntityFurnace ec = null;
        nearby_list = DangerZone.clientEntityManager.findEntitiesInRange(2.0f, dimension, (double)x, (double)y, (double)z);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = (Entity)li.next();
                if (!(e instanceof EntityFurnace)) continue;
                if ((int)e.posx == x && (int)e.posy == y && (int)e.posz == z) {
                    ec = (EntityFurnace)e;
                    break;
                }
                ec = null;
            }
        }
        if (ec == null) {
            Entity eb = p.world.createEntityByName("DangerZone:EntityFurnace", dimension, (double)x + 0.5, (double)y + (double)0.05f, (double)z + 0.5);
            if (eb != null) {
                eb.init();
                eb.setBID(OreSpawnMain.crystalfurnace.blockID);
                eb.setIID(OreSpawnMain.crystalfurnaceOn.blockID);
                p.world.spawnEntityInWorld(eb);
            }
            return false;
        }
        DangerZone.furnacegui.ec = ec;
        DangerZone.setActiveGui((GuiInterface)DangerZone.furnacegui);
        return false;
    }

    public void onBlockPlaced(World w, int dimension, int x, int y, int z) {
        Entity eb;
        if (w.isServer && (eb = w.createEntityByName("DangerZone:EntityFurnace", dimension, (double)x + 0.5, (double)y + (double)0.05f, (double)z + 0.5)) != null) {
            eb.init();
            eb.setBID(OreSpawnMain.crystalfurnace.blockID);
            eb.setIID(OreSpawnMain.crystalfurnaceOn.blockID);
            w.spawnEntityInWorld(eb);
        }
    }

    public Texture getTexture(int side) {
        if (this.ttop == null) {
            this.ttop = this.initBlockTexture(this.topname);
        }
        if (this.tfront == null) {
            this.tfront = this.initBlockTexture(this.frontname);
        }
        if (this.tside == null) {
            this.tside = this.initBlockTexture(this.sidename);
        }
        if (side == 0) {
            return this.ttop;
        }
        if (side == 1) {
            return this.tfront;
        }
        return this.tside;
    }

    public StitchedTexture getStitchedTexture(int side) {
        if (side == 0) {
            return this.sttop;
        }
        if (side == 1) {
            return this.stfront;
        }
        return this.stside;
    }

    public String getStitchedTextureName(int side) {
        if (side == 0) {
            return this.topname;
        }
        if (side == 1) {
            return this.frontname;
        }
        return this.sidename;
    }
}

